# Ear Candy - Pulseaduio sound managment tool
# Copyright (C) 2008 Jason Taylor
# 
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


import dbus
import dbus.service
import dbus.glib
import gobject

DBUS_KEY = "org.earCandy.EarCandyDBus"

class EarCandyDBusClient(dbus.service.Object):
    
    def __init__(self, core):
        self.core = core
    

    def is_running(self):
        dbus.mainloop.glib.DBusGMainLoop (set_as_default=True)
        bus = dbus.SessionBus ()
        request = bus.request_name (DBUS_KEY, dbus.bus.NAME_FLAG_DO_NOT_QUEUE)
        return request == dbus.bus.REQUEST_NAME_REPLY_EXISTS

    def start_service(self):
        self.ec = EarCandyDBusService(self.core)

    def show_window(self):
        # call first app via dbus
        dbus.mainloop.glib.DBusGMainLoop (set_as_default=True)
        bus = dbus.SessionBus ()
        request = bus.request_name (DBUS_KEY, dbus.bus.NAME_FLAG_DO_NOT_QUEUE)
        obj = bus.get_object (DBUS_KEY, "/")
        obj.ShowWindow(dbus_interface = DBUS_KEY)

class EarCandyDBusService(dbus.service.Object):
    def __init__(self, core):
        self.core = core
        dbus.mainloop.glib.DBusGMainLoop (set_as_default=True)
        bus = dbus.SessionBus ()
        dbus.service.Object.__init__(self, bus, "/", DBUS_KEY)
        print    
        print "registered as dbus service..."
        print

    @dbus.service.method(DBUS_KEY)
    def ShowWindow( self ):
        # I have no idea what thread this is on.. at a guesss its gtk main...
        gobject.idle_add(self.core.open_preferances)
        return False










